/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.sql.DataSource;
import org.assertj.core.api.Assertions;
import org.codefilarete.stalactite.engine.PersistenceContext;
import org.codefilarete.stalactite.engine.crud.BatchDelete;
import org.codefilarete.stalactite.engine.crud.BatchInsert;
import org.codefilarete.stalactite.engine.crud.BatchUpdate;
import org.codefilarete.stalactite.query.model.ConditionalOperator;
import org.codefilarete.stalactite.query.model.Operators;
import org.codefilarete.stalactite.query.model.QueryEase;
import org.codefilarete.stalactite.query.model.Selectable;
import org.codefilarete.stalactite.query.model.Where;
import org.codefilarete.stalactite.sql.ConnectionProvider;
import org.codefilarete.stalactite.sql.Dialect;
import org.codefilarete.stalactite.sql.SimpleConnectionProvider;
import org.codefilarete.stalactite.sql.ddl.DDLDeployer;
import org.codefilarete.stalactite.sql.ddl.structure.Column;
import org.codefilarete.stalactite.sql.ddl.structure.Table;
import org.codefilarete.stalactite.sql.hsqldb.test.HSQLDBInMemoryDataSource;
import org.codefilarete.stalactite.sql.result.Accumulators;
import org.codefilarete.stalactite.sql.result.InMemoryResultSet;
import org.codefilarete.stalactite.test.DefaultDialect;
import org.codefilarete.tool.Duo;
import org.codefilarete.tool.collection.Arrays;
import org.codefilarete.tool.collection.Maps;
import org.danekja.java.util.function.serializable.SerializableFunction;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.internal.matchers.CapturingMatcher;
import org.mockito.internal.util.Primitives;

public class PersistenceContextTest {
    private static <T> T capture(Class<T> type, CapturingMatcher<Object> capturingMatcher) {
        Mockito.argThat(capturingMatcher);
        return (T)Primitives.defaultValue(type);
    }

    @Test
    void insert() throws SQLException {
        Connection connectionMock = (Connection)Mockito.mock(Connection.class);
        PreparedStatement preparedStatementMock = (PreparedStatement)Mockito.mock(PreparedStatement.class);
        ArgumentCaptor sqlStatementCaptor = ArgumentCaptor.forClass(String.class);
        Mockito.when((Object)connectionMock.prepareStatement((String)sqlStatementCaptor.capture())).thenReturn((Object)preparedStatementMock);
        CapturingMatcher valuesStatementCaptor = new CapturingMatcher();
        ((PreparedStatement)Mockito.doNothing().when((Object)preparedStatementMock)).setLong(PersistenceContextTest.capture(Integer.TYPE, (CapturingMatcher<Object>)valuesStatementCaptor), PersistenceContextTest.capture(Long.TYPE, (CapturingMatcher<Object>)valuesStatementCaptor));
        ((PreparedStatement)Mockito.doNothing().when((Object)preparedStatementMock)).setString(PersistenceContextTest.capture(Integer.TYPE, (CapturingMatcher<Object>)valuesStatementCaptor), PersistenceContextTest.capture(String.class, (CapturingMatcher<Object>)valuesStatementCaptor));
        PersistenceContext testInstance = new PersistenceContext((ConnectionProvider)new SimpleConnectionProvider(connectionMock), (Dialect)new DefaultDialect());
        Table totoTable = new Table("toto");
        Column id = totoTable.addColumn("id", Long.TYPE);
        Column name = totoTable.addColumn("name", String.class);
        testInstance.insert(totoTable).set(id, (Object)1L).set(name, (Object)"Hello world !").execute();
        Assertions.assertThat((String)((String)sqlStatementCaptor.getValue())).isEqualTo("insert into toto(id, name) values (?, ?)");
        ArrayList<Duo> statementArgsPairs = new ArrayList<Duo>();
        List capturedStatementArgs = valuesStatementCaptor.getAllValues();
        int allValuesSize = capturedStatementArgs.size();
        for (int i = 0; i < allValuesSize; i += 2) {
            int index = (Integer)capturedStatementArgs.get(i);
            Object value = capturedStatementArgs.get(i + 1);
            statementArgsPairs.add(new Duo((Object)index, value));
        }
        Assertions.assertThat(statementArgsPairs).containsExactlyInAnyOrder((Object[])new Duo[]{new Duo((Object)1, (Object)1L), new Duo((Object)2, (Object)"Hello world !")});
    }

    @Test
    void insert_batch() {
        PersistenceContext testInstance = new PersistenceContext((ConnectionProvider)new ConnectionProvider.DataSourceConnectionProvider((DataSource)new HSQLDBInMemoryDataSource()), (Dialect)new DefaultDialect());
        Table totoTable = new Table("toto");
        Column id = totoTable.addColumn("id", Long.TYPE).primaryKey();
        Column name = totoTable.addColumn("name", String.class);
        DDLDeployer ddlDeployer = new DDLDeployer(testInstance);
        ddlDeployer.getDdlGenerator().addTables(totoTable, new Table[0]);
        ddlDeployer.deployDDL();
        BatchInsert batchInsert = testInstance.batchInsert(totoTable);
        long effectiveWrite = batchInsert.set(id, (Object)1L).set(name, (Object)"Hello world !").newRow().set(id, (Object)2L).set(name, (Object)"Hello everybody !").execute();
        Assertions.assertThat((long)effectiveWrite).isEqualTo(2L);
        List select = testInstance.select(SerializableFunction.identity(), id);
        Assertions.assertThat((List)select).containsExactly((Object[])new Long[]{1L, 2L});
        effectiveWrite = batchInsert.newRow().set(id, (Object)3L).set(name, (Object)"Hello world !").newRow().set(id, (Object)4L).set(name, (Object)"Hello everybody !").execute();
        Assertions.assertThat((long)effectiveWrite).isEqualTo(2L);
        select = testInstance.select(SerializableFunction.identity(), id);
        Assertions.assertThat((List)select).containsExactly((Object[])new Long[]{1L, 2L, 3L, 4L});
    }

    @Test
    void update() throws SQLException {
        Connection connectionMock = (Connection)Mockito.mock(Connection.class);
        PreparedStatement preparedStatementMock = (PreparedStatement)Mockito.mock(PreparedStatement.class);
        ArgumentCaptor sqlStatementCaptor = ArgumentCaptor.forClass(String.class);
        Mockito.when((Object)connectionMock.prepareStatement((String)sqlStatementCaptor.capture())).thenReturn((Object)preparedStatementMock);
        CapturingMatcher valuesStatementCaptor = new CapturingMatcher();
        ((PreparedStatement)Mockito.doNothing().when((Object)preparedStatementMock)).setLong(ArgumentMatchers.anyInt(), PersistenceContextTest.capture(Long.TYPE, (CapturingMatcher<Object>)valuesStatementCaptor));
        ((PreparedStatement)Mockito.doNothing().when((Object)preparedStatementMock)).setString(ArgumentMatchers.anyInt(), PersistenceContextTest.capture(String.class, (CapturingMatcher<Object>)valuesStatementCaptor));
        PersistenceContext testInstance = new PersistenceContext((ConnectionProvider)new SimpleConnectionProvider(connectionMock), (Dialect)new DefaultDialect());
        Table totoTable = new Table("toto");
        Column id = totoTable.addColumn("id", Long.TYPE);
        Column name = totoTable.addColumn("name", String.class);
        testInstance.update(totoTable).set(id, (Object)1L).execute();
        Assertions.assertThat((String)((String)sqlStatementCaptor.getValue())).isEqualTo("update toto set id = ?");
        Assertions.assertThat((List)valuesStatementCaptor.getAllValues()).containsExactly(new Object[]{1L});
    }

    @Test
    void update_batch() {
        PersistenceContext testInstance = new PersistenceContext((ConnectionProvider)new ConnectionProvider.DataSourceConnectionProvider((DataSource)new HSQLDBInMemoryDataSource()), (Dialect)new DefaultDialect());
        Table totoTable = new Table("toto");
        Column idColumn = totoTable.addColumn("id", Long.TYPE).primaryKey();
        Column nameColumn = totoTable.addColumn("name", String.class);
        DDLDeployer ddlDeployer = new DDLDeployer(testInstance);
        ddlDeployer.getDdlGenerator().addTables(totoTable, new Table[0]);
        ddlDeployer.deployDDL();
        testInstance.batchInsert(totoTable).set(idColumn, (Object)1L).set(nameColumn, (Object)"Hello world !").newRow().set(idColumn, (Object)2L).set(nameColumn, (Object)"Hello everybody !").execute();
        Assertions.assertThat((List)testInstance.select(SerializableFunction.identity(), idColumn)).containsExactly((Object[])new Long[]{1L, 2L});
        BatchUpdate batchUpdate = testInstance.batchUpdate(totoTable, (Set)Arrays.asSet((Object[])new Column[]{nameColumn}), QueryEase.where((Selectable)idColumn, (ConditionalOperator)Operators.equalsArgNamed((String)"pk", Long.class)));
        long effectiveWrite = batchUpdate.set(nameColumn, (Object)"Hello world !").set("pk", (Object)2L).execute();
        Assertions.assertThat((List)testInstance.select(SerializableFunction.identity(), nameColumn)).containsExactly((Object[])new String[]{"Hello world !", "Hello world !"});
        Assertions.assertThat((long)effectiveWrite).isEqualTo(1L);
        effectiveWrite = batchUpdate.set(nameColumn, (Object)"Hello John !").set("pk", (Object)1L).newRow().set(nameColumn, (Object)"Hello Jane !").set("pk", (Object)2L).execute();
        Assertions.assertThat((List)testInstance.select(SerializableFunction.identity(), nameColumn)).containsExactly((Object[])new String[]{"Hello John !", "Hello Jane !"});
        Assertions.assertThat((long)effectiveWrite).isEqualTo(2L);
    }

    @Test
    void update_withWhere() throws SQLException {
        Connection connectionMock = (Connection)Mockito.mock(Connection.class);
        PreparedStatement preparedStatementMock = (PreparedStatement)Mockito.mock(PreparedStatement.class);
        ArgumentCaptor sqlStatementCaptor = ArgumentCaptor.forClass(String.class);
        Mockito.when((Object)connectionMock.prepareStatement((String)sqlStatementCaptor.capture())).thenReturn((Object)preparedStatementMock);
        CapturingMatcher valuesStatementCaptor = new CapturingMatcher();
        ((PreparedStatement)Mockito.doNothing().when((Object)preparedStatementMock)).setLong(ArgumentMatchers.anyInt(), PersistenceContextTest.capture(Long.TYPE, (CapturingMatcher<Object>)valuesStatementCaptor));
        ((PreparedStatement)Mockito.doNothing().when((Object)preparedStatementMock)).setString(ArgumentMatchers.anyInt(), PersistenceContextTest.capture(String.class, (CapturingMatcher<Object>)valuesStatementCaptor));
        PersistenceContext testInstance = new PersistenceContext((ConnectionProvider)new SimpleConnectionProvider(connectionMock), (Dialect)new DefaultDialect());
        Table totoTable = new Table("toto");
        Column id = totoTable.addColumn("id", Long.TYPE);
        Column name = totoTable.addColumn("name", String.class);
        testInstance.update(totoTable, QueryEase.where((Selectable)id, (ConditionalOperator)Operators.eq((Object)666L))).set(id, (Object)42L).execute();
        Assertions.assertThat((String)((String)sqlStatementCaptor.getValue())).isEqualTo("update toto set id = ? where id = ?");
        Assertions.assertThat((List)valuesStatementCaptor.getAllValues()).containsExactly(new Object[]{42L, 666L});
    }

    @Test
    void delete() throws SQLException {
        Connection connectionMock = (Connection)Mockito.mock(Connection.class);
        PreparedStatement preparedStatementMock = (PreparedStatement)Mockito.mock(PreparedStatement.class);
        ArgumentCaptor sqlStatementCaptor = ArgumentCaptor.forClass(String.class);
        Mockito.when((Object)connectionMock.prepareStatement((String)sqlStatementCaptor.capture())).thenReturn((Object)preparedStatementMock);
        CapturingMatcher valuesStatementCaptor = new CapturingMatcher();
        ((PreparedStatement)Mockito.doNothing().when((Object)preparedStatementMock)).setLong(ArgumentMatchers.anyInt(), PersistenceContextTest.capture(Long.TYPE, (CapturingMatcher<Object>)valuesStatementCaptor));
        ((PreparedStatement)Mockito.doNothing().when((Object)preparedStatementMock)).setString(ArgumentMatchers.anyInt(), PersistenceContextTest.capture(String.class, (CapturingMatcher<Object>)valuesStatementCaptor));
        PersistenceContext testInstance = new PersistenceContext((ConnectionProvider)new SimpleConnectionProvider(connectionMock), (Dialect)new DefaultDialect());
        Table totoTable = new Table("toto");
        Column id = totoTable.addColumn("id", Long.TYPE);
        Column name = totoTable.addColumn("name", String.class);
        testInstance.delete(totoTable, (Where)QueryEase.where((Selectable)id, (ConditionalOperator)Operators.eq((Object)42L)).and(name, (ConditionalOperator)Operators.eq((Object)"Hello world !"))).execute();
        Assertions.assertThat((String)((String)sqlStatementCaptor.getValue())).isEqualTo("delete from toto where id = ? and name = ?");
        Assertions.assertThat((List)valuesStatementCaptor.getAllValues()).containsExactly(new Object[]{42L, "Hello world !"});
    }

    @Test
    void delete_batch() {
        PersistenceContext testInstance = new PersistenceContext((ConnectionProvider)new ConnectionProvider.DataSourceConnectionProvider((DataSource)new HSQLDBInMemoryDataSource()), (Dialect)new DefaultDialect());
        Table totoTable = new Table("toto");
        Column idColumn = totoTable.addColumn("id", Long.TYPE).primaryKey();
        Column nameColumn = totoTable.addColumn("name", String.class);
        DDLDeployer ddlDeployer = new DDLDeployer(testInstance);
        ddlDeployer.getDdlGenerator().addTables(totoTable, new Table[0]);
        ddlDeployer.deployDDL();
        testInstance.batchInsert(totoTable).set(idColumn, (Object)1L).set(nameColumn, (Object)"Hello world !").newRow().set(idColumn, (Object)2L).set(nameColumn, (Object)"Hello everybody !").newRow().set(idColumn, (Object)3L).set(nameColumn, (Object)"Hello everyone !").execute();
        BatchDelete deleteStatement = testInstance.batchDelete(totoTable, QueryEase.where((Selectable)nameColumn, (ConditionalOperator)Operators.equalsArgNamed((String)"name", String.class)));
        long execute = deleteStatement.set("name", (Object)"Hello world !").newRow().set("name", (Object)"Hello everybody !").execute();
        Assertions.assertThat((long)execute).isEqualTo(2L);
        Assertions.assertThat((List)testInstance.select(SerializableFunction.identity(), idColumn)).containsExactly((Object[])new Long[]{3L});
        execute = deleteStatement.set("name", (Object)"Hello everyone !").execute();
        Assertions.assertThat((long)execute).isEqualTo(1L);
        Assertions.assertThat((List)testInstance.select(SerializableFunction.identity(), idColumn)).isEmpty();
    }

    @Test
    void newQuery_singleResult() throws SQLException {
        Connection connectionMock = (Connection)Mockito.mock(Connection.class);
        PreparedStatement preparedStatementMock = (PreparedStatement)Mockito.mock(PreparedStatement.class);
        ArgumentCaptor sqlStatementCaptor = ArgumentCaptor.forClass(String.class);
        Mockito.when((Object)connectionMock.prepareStatement((String)sqlStatementCaptor.capture())).thenReturn((Object)preparedStatementMock);
        CapturingMatcher valuesStatementCaptor = new CapturingMatcher();
        ((PreparedStatement)Mockito.doNothing().when((Object)preparedStatementMock)).setLong(ArgumentMatchers.anyInt(), PersistenceContextTest.capture(Long.TYPE, (CapturingMatcher<Object>)valuesStatementCaptor));
        ((PreparedStatement)Mockito.doNothing().when((Object)preparedStatementMock)).setString(ArgumentMatchers.anyInt(), PersistenceContextTest.capture(String.class, (CapturingMatcher<Object>)valuesStatementCaptor));
        Mockito.when((Object)preparedStatementMock.executeQuery()).thenReturn((Object)new InMemoryResultSet((Iterable)Arrays.asList((Object[])new Maps.ChainingHashMap[]{Maps.forHashMap(String.class, Object.class).add((Object)"id", (Object)42).add((Object)"name", (Object)"tata").add((Object)"count", (Object)666)})));
        PersistenceContext testInstance = new PersistenceContext((ConnectionProvider)new SimpleConnectionProvider(connectionMock), (Dialect)new DefaultDialect());
        Integer count = (Integer)testInstance.newQuery((CharSequence)"select count(*) as count from Toto", Integer.class).mapKey("count", Integer.class).execute(Accumulators.getFirst());
        Assertions.assertThat((Integer)count).isEqualTo(666);
        Assertions.assertThat((String)((String)sqlStatementCaptor.getValue())).isEqualTo("select count(*) as count from Toto");
        Assertions.assertThat((List)valuesStatementCaptor.getAllValues()).isEmpty();
    }
}

